<?php

namespace Egytca;

class App {

	private $environment;

	private $readableProperties = ['environment'];

	function __construct() {

		if (!isset($_SERVER['env']))
		    $_SERVER['env'] = 'prod';

		$this->environment = $_SERVER['env'];
		if (!in_array($this->environment, array('prod', 'dev', 'test')))
		    throw new Exception('invalid environment');
	}

	function __get($name) {

		if (in_array($name, $this->readableProperties)) {
			return $this->$name;
		}

		$trace = debug_backtrace();
		$notice = 'Undefined property: '.$name
			.' in <strong>'.$trace[0]['file'].'</strong>'
			.' on line '.$trace[0]['line'];
		trigger_error($notice, E_USER_NOTICE);
	}

	function isDev() {
		return $this->environment == 'dev';
	}
}